<?php
global $houzez_opt_name;

Redux::setSection( $houzez_opt_name, array(
    'title'  => esc_html__( 'Typography', 'houzez' ),
    'id'     => 'houzez-typography',
    'desc'   => '',
    'icon'   => 'el-icon-font el-icon-small',
    'fields'  => array(
        array(
            'id'          => 'typo-body',
            'type'        => 'typography',
            'title'       => esc_html__('Body', 'houzez'),
            'google'      => true,
            'font-family' => true,
            'color'       => false,
            'font-backup' => false,
            'text-align'  => false,
            'text-transform' => true,
            'font-style' => false,
            'units'       =>'px',
            'subtitle'    => esc_html__('Select the main content font.', 'houzez'),
            'all_styles'  => true,
            'default'     => array(
                'font-weight'  => '300',
                'font-family' => 'Roboto',
                'google'      => true,
                'font-size'   => '15px',
                'line-height' => '25px',
                'text-transform' => 'none'
            ),
        ),

        // Typo headers
        array(
            'id'          => 'typo-headers',
            'type'        => 'typography',
            'title'       => esc_html__('Navigations', 'houzez'),
            'google'      => true,
            'font-family' => true,
            'line-height' => false,
            'font-backup' => false,
            'text-align'  => true,
            'text-transform' => true,
            'color' => false,
            'font-style' => false,
            'units'       =>'px',
            'subtitle'    => esc_html__('Select the navigation font.', 'houzez'),
            'default'     => array(
                'font-family' => 'Roboto',
                'font-weight'  => '500',
                'google'      => true,
                'font-size'   => '14px',
                'text-align' => 'left',
                'text-transform' => 'none',
            ),
        ),

        array(
            'id'        => 'navigation-letter-spacing',
            'type'      => 'slider',
            'title'     => esc_html__('Letter Spacing', 'houzez'),
            'subtitle'  => esc_html__('Navigation letter spacing', 'houzez'),
            "default" => 0,
            "min" => 0,
            "step" => .5,
            "max" => 10,
            'resolution' => 0.1,
            'display_value' => 'text'
        ),

        // Typo headers
        array(
            'id'          => 'typo-footer',
            'type'        => 'typography',
            'title'       => esc_html__('Footer', 'houzez'),
            'google'      => true,
            'font-family' => true,
            'line-height' => true,
            'font-backup' => false,
            'text-align'  => true,
            'text-transform' => true,
            'color' => false,
            'font-style' => false,
            'units'       =>'px',
            'subtitle'    => esc_html__('Select the footer font.', 'houzez'),
            'default'     => array(
                'font-family' => 'Roboto',
                'font-weight'  => '300',
                'google'      => true,
                'font-size'   => '14px',
                'line-height'   => '25px',
                'text-align' => 'left',
                'text-transform' => 'none',
            ),
        ),
        array(
            'id'          => 'typo-topbar',
            'type'        => 'typography',
            'title'       => esc_html__('Top Bar', 'houzez'),
            'google'      => true,
            'font-family' => true,
            'line-height' => true,
            'font-backup' => false,
            'text-align'  => true,
            'text-transform' => true,
            'color' => false,
            'font-style' => false,
            'units'       =>'px',
            'subtitle'    => esc_html__('Select the top bar font.', 'houzez'),
            'default'     => array(
                'font-family' => 'Roboto',
                'font-weight'  => '300',
                'google'      => true,
                'font-size'   => '15px',
                'line-height'   => '25px',
                'text-align' => 'left',
                'text-transform' => 'none',
            ),
        ),

        // Typo Headings 1
        array(
            'id'          => 'typo-headings',
            'type'        => 'typography',
            'title'       => esc_html__('Headings', 'houzez'),
            'google'      => true,
            'font-family' => true,
            'font-backup' => false,
            'text-align'  => true,
            'font-size'   => false,
            'line-height'   => false,
            'text-transform' => true,
            'color' => false,
            'font-style' => false,
            'units'       =>'px',
            'subtitle'    => esc_html__('Select the heading font ( h1, h2, h3, h3 etc ).', 'houzez'),
            'default'     => array(
                'font-family' => 'Roboto',
                'font-weight'  => '500',
                'google'      => true,
                'text-transform' => 'inherit',
                'text-align' => 'inherit'
            ),
        ),
    ),
));